﻿;---------------------------------------------------
;  _____  _____ _   _                 _       _____ _      _____ _             _ _         _                            _               
; |_   _|/ ____| \ | |     /\        | |     |_   _| |    / ____| |           | (_)       | |                          | |              
;   | | | (___ |  \| |    /  \  _   _| |_ ___  | | | |_  | (___ | |_ _   _  __| |_  ___   | |     __ _ _   _ _ __   ___| |__   ___ _ __ 
;   | |  \___ \| . ` |   / /\ \| | | | __/ _ \ | | | __|  \___ \| __| | | |/ _` | |/ _ \  | |    / _` | | | | '_ \ / __| '_ \ / _ \ '__|
;  _| |_ ____) | |\  |  / ____ \ |_| | || (_) || |_| |_   ____) | |_| |_| | (_| | | (_) | | |___| (_| | |_| | | | | (__| | | |  __/ |   
; |_____|_____/|_| \_| /_/    \_\__,_|\__\___/_____|\__| |_____/ \__|\__,_|\__,_|_|\___/  |______\__,_|\__,_|_| |_|\___|_| |_|\___|_|   
;                                                                                                                                                                                                                                                                        
; by ISI360 (Christian Faderl)
;---------------------------------------------------
;
; This file is used to act as an launcher for the ISN AutoIt Studio to redurce false positive alerts for AV scanners.
; It acts an an wrapper to start the AutoIt_Studio.a3x with the integrated AutoIt3.exe.
; It also passes all parameters to the AutoIt3.exe.
;
; NOTE: This script is written in PureBasic, not AutoIt!
;
;---------------------------------------------------

;Setup
Parameters.s = ""
AutoIt3_x86Path.s = GetPathPart(ProgramFilename()) + "Data\AutoIt3.exe"
ISNStudioa3xPath.s = GetPathPart(ProgramFilename()) + "AutoIt_Studio.a3x"
Quote.s = Chr(34)

;Collect input parameters
For i = 0 To CountProgramParameters()-1
  Parameters = Parameters + Quote + ProgramParameter(i) + Quote + " "
Next
Parameters = RTrim(Parameters)

;Some checks before starting
If FileSize(ISNStudioa3xPath) = -1
   MessageRequester("Error", "AutoIt_Studio.a3x not found!", #PB_MessageRequester_Ok + #PB_MessageRequester_Error) 
  End
EndIf 

If FileSize(AutoIt3_x86Path) = -1
   MessageRequester("Error", "Data\AutoIt3.exe not found!", #PB_MessageRequester_Ok + #PB_MessageRequester_Error) 
  End
EndIf 

;Run the new instance
RunProgram(Quote + AutoIt3_x86Path + Quote + " " + Quote + ISNStudioa3xPath + Quote,Parameters,GetCurrentDirectory())

;Exit
End 
; IDE Options = PureBasic 5.73 LTS (Windows - x64)
; CursorPosition = 7
; EnableXP
; DPIAware
; UseIcon = autoitstudioicon.ico
; Executable = Autoit_Studio.exe
; DisableDebugger
; Compiler = PureBasic 5.72 (Windows - x86) Free
; IncludeVersionInfo
; VersionField0 = 1,0,0,0
; VersionField1 = 1,0,0,0
; VersionField3 = ISN AutoIt Studio Launcher
; VersionField4 = 1.0
; VersionField5 = 1.0
; VersionField6 = ISN AutoIt Studio Launcher
; VersionField7 = ISN AutoIt Studio Launcher
; VersionField9 = ISI360
; VersionField14 = https://www.isnetwork.at
; VersionField16 = VFT_APP